/* 
 *  MonitoredUserEventTask.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.MonitoredUserI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.ResponseData;
import com.avaya.ccs.api.enums.NotificationType;

import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;

public class MonitoredUserEventTask extends Task<MonitoredUserData> {

    private final NotificationEventI<MonitoredUserI> user;
    private final SupervisorDataGUI gui;
    private static final Logger LOG = Logger.getLogger(MonitoredUserEventTask.class);

    public MonitoredUserEventTask(NotificationEventI<MonitoredUserI> user, SupervisorDataGUI gui) {
        this.user = user;
        this.gui = gui;
        setupJavaFXApplicationSucceededHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded((WorkerStateEvent t) -> {
            String methodName = "succeededHandler() ";
            MonitoredUserData value = (MonitoredUserData) t.getSource().getValue();
            if (value != null) {
                if (!value.isDeleted())
                    LOG.info(methodName + "MonitoredUserData:" + value);
                else
                    LOG.info(methodName + "Deletion of MonitoredUserData-ID:" + value.getId());
                gui.UpdateMonitoredUserData(value);
            } else {
                LOG.debug(methodName + " NULL");
            }
        });
    }

    /**
     * The call method executes on the incomingEvent thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected MonitoredUserData call() throws Exception {
        String methodName = "call() ";
        MonitoredUserData data = null;
        NotificationType type = user.getNotificationType();
        LOG.debug(methodName + "Type:" + type + " ID:" + user.getNotificationObject().getId());

        switch (type) {
        case UPDATE:
            data = new MonitoredUserData(user.getNotificationObject());
            break;
        case DELETE:
            data = new MonitoredUserData(user.getNotificationObject().getId(), true);
            break;
        case ERROR:
            LOG.errorStatus(user.getError());
            break;
        case NEW:
            data = new MonitoredUserData(user.getNotificationObject());

            break;
        case RESPONSE:
            // need to convert the response to the code list object
            // this response contains a code list associated with a user

            ResponseData resp = user.getResponseData();
            if (resp instanceof CodeListI) {
                LOG.debug(methodName + " type of codelist");
                data = new MonitoredUserData(null);
            }
            break;
        case UNKNOWN:
            break;
        }
        return data;
    }
}
